import math
import time

def newtons_method(x0, f, f1, e):
    #f1 - производная
    while True:
        x1 = x0 - (f(x0) / f1(x0))
        if abs(x1 - x0) < e:
            return x1
        x0 = x1

# !!! Импортируем один из пакетов Matplotlib
import matplotlib.pyplot as pylab

# !!! Импортируем пакет со вспомогательными функциями
from matplotlib import mlab

# Будем рисовать график этой функции
def func (x,c):
    """
    sinc (x)
    """
    return x**2-c

# Интервал изменения переменной по оси X
xmin = -5
xmax =  5
c = 3
# Шаг между точками
dx = 0.01

# !!! Создадим список координат по оси X на отрезке [-xmin; xmax], включая концы
xlist = mlab.frange (xmin, xmax, dx)

# Вычислим значение функции в заданных точках
ylist = [func (x,c) for x in xlist]

# !!! Нарисуем одномерный график
pylab.plot (xlist, ylist,linewidth=2)
pylab.plot(xlist,[0 for x in xlist], linestyle='dashed')
# !!! Покажем окно с нарисованным графиком
pylab.show()

x0 = 1
e = 0.0001

old = 100
while abs(x0-old) > e:
    old = x0
    y2 = [func(x0,c)+ 2*x0*(x-x0) for x in xlist]
    print('x0 = ',x0)
    print('f('+str(x0)+') = ',func(x0,c))
    time.sleep(1)
    pylab.plot (xlist, ylist,linewidth=2)
    pylab.plot(xlist,[0 for x in xlist], linestyle='dashed')
    pylab.plot(xlist,y2)
    pylab.plot([x0 for x in xlist],xlist)
    x0 = x0 - func(x0,c)/(2*x0)
    pylab.plot([x0 for x in xlist],xlist)
    pylab.show()
