import random

G = 2 # number of sides
R = 50 # number of dices
N = R*500 # number of experiments

a = range(G)
All = [0]*G

def d():
    dot = random.random()
    All[int(dot*G)] += 1
    #print(All)
    return a[int(dot*G)]

def nd():
    return sum([d() for i in range(R)])/R

arr = [0]*(R*(G-1)+1)
for i in range(N):
    dot = nd()
    arr[int(round(dot*R,0))] += 1

arr = [x/N*100 for x in arr]
x,y = [],[]
for i in range(len(arr)):
    x.append(i/R)
    y.append(arr[i])

xmin = min([x[i] for i in range(len(x)) if y[i]!=0])
xmax = max([x[i] for i in range(len(x)) if y[i]!=0])

import numpy as np
import matplotlib.mlab as mlab
import matplotlib.pyplot as plt

plt.plot(x,y)
plt.xlabel('Average')
plt.ylabel('Share (%)')
plt.title(r'Rolling dices')
plt.xlim(xmin, xmax)
#plt.axis([0, G-1,0,100])
plt.grid(True)

plt.show()
